/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class RankRenderer {
    static ResourceLocation RankImg = new ResourceLocation("slashblade", "textures/gui/rank.png");

    public static RankRenderer getInstance() {
        return SingletonHolder.instance;
    }

    private RankRenderer() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void renderTick(RenderGuiOverlayEvent.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        if (!Minecraft.m_91404_()) {
            return;
        }
        if (mc.f_91080_ != null && !(mc.f_91080_ instanceof ChatScreen)) {
            return;
        }
        ClientLevel world = mc.f_91073_;
        LocalPlayer player = mc.f_91074_;
        long time = System.currentTimeMillis();
        this.renderRankHud(Float.valueOf(event.getPartialTick()), player, time);
    }

    private void renderRankHud(Float partialTicks, LocalPlayer player, long time) {
        Minecraft mc = Minecraft.m_91087_();
        player.getCapability(CapabilityConcentrationRank.RANK_POINT).ifPresent(cr -> {
            long now = player.m_9236_().m_46467_();
            IConcentrationRank.ConcentrationRanks rank = cr.getRank(now);
            if (rank == IConcentrationRank.ConcentrationRanks.NONE) {
                return;
            }
            int k = mc.m_91268_().m_85445_();
            int l = mc.m_91268_().m_85446_();
            PoseStack poseStack = new PoseStack();
            poseStack.m_252880_((float)(k * 2 / 3), (float)(l / 5), 0.0f);
            RenderSystem.disableDepthTest();
            TextureManager texturemanager = Minecraft.m_91087_().m_91097_();
            texturemanager.m_118506_(RankImg).m_117960_(false, false);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)RankImg);
            boolean showTextRank = false;
            long textTimeout = cr.getLastRankRise() + 20L;
            long visibleTimeout = cr.getLastUpdate() + 120L;
            if (now < textTimeout) {
                showTextRank = true;
            }
            if (now < visibleTimeout) {
                int rankOffset = 32 * (rank.level - 1);
                int textOffset = showTextRank ? 128 : 0;
                int progress = (int)(33.0f * cr.getRankProgress(now));
                int progressIcon = (int)(18.0f * cr.getRankProgress(now));
                int progressIconInv = 17 - progressIcon;
                RankRenderer.drawTexturedQuad(poseStack, 0, 0, 0 + textOffset + 64, rankOffset, 64, 32, -95.0f);
                RankRenderer.drawTexturedQuad(poseStack, 0, progressIconInv + 7, 0 + textOffset, rankOffset + progressIconInv + 7, 64, progressIcon, -90.0f);
                RankRenderer.drawTexturedQuad(poseStack, 0, 32, 0, 240, 64, 16, -90.0f);
                RankRenderer.drawTexturedQuad(poseStack, 16, 32, 16, 224, progress, 16, -95.0f);
            }
        });
    }

    public static void drawTexturedQuad(PoseStack poseStack, int x, int y, int u, int v, int width, int height, float zLevel) {
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        RenderSystem.setShader(GameRenderer::m_172817_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder wr = tessellator.m_85915_();
        wr.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        Matrix4f m = poseStack.m_85850_().m_252922_();
        wr.m_252986_(m, (float)(x + 0), (float)(y + height), zLevel).m_7421_(((float)u + 0.0f) * var7, (float)(v + height) * var8).m_5752_();
        wr.m_252986_(m, (float)(x + width), (float)(y + height), zLevel).m_7421_((float)(u + width) * var7, (float)(v + height) * var8).m_5752_();
        wr.m_252986_(m, (float)(x + width), (float)(y + 0), zLevel).m_7421_((float)(u + width) * var7, (float)(v + 0) * var8).m_5752_();
        wr.m_252986_(m, (float)(x + 0), (float)(y + 0), zLevel).m_7421_((float)(u + 0) * var7, (float)(v + 0) * var8).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)wr.m_231175_());
    }

    private static final class SingletonHolder {
        private static final RankRenderer instance = new RankRenderer();

        private SingletonHolder() {
        }
    }
}

